import sys

sys.path.append('../LEAP_Hand_API/python')
from leap_hand_utils.dynamixel_client import *
import leap_hand_utils.leap_hand_utils as lhu
import time




class LeapNode:
    def __init__(self):
        
        self.kP = 800
        self.kI = 0
        self.kD = 200
        
        
        self.curr_lim = 300
        # self.curr_lim = 500
        
        init_pos = [ 0.1451,  0.0797,  0.5086,  0.4145,  0.4700,  0.7530,  1.2950, -0.2015,
         0.2630, -0.1050,  0.3566,  0.2325,  0.3979, -0.1960,  0.2432,  0.3852]
        
        joint_idxes_ordering = [1, 0, 2, 3, 9, 8, 10, 11, 13, 12, 14, 15, 4, 5, 6, 7]
        joint_idxes_ordering = np.array(joint_idxes_ordering).astype(np.int32)
        
        init_pos = np.array(init_pos, dtype=np.float32)
        init_pos = init_pos[joint_idxes_ordering]
        
        # self.prev_pos = self.pos = self.curr_pos = lhu.allegro_to_LEAPhand(np.zeros(16))
        
        self.prev_pos = self.pos = self.curr_pos = lhu.allegro_to_LEAPhand(init_pos)
           
        #You can put the correct port here or have the node auto-search for a hand at the first 3 ports.
        self.motors = motors = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
        try:
            self.dxl_client = DynamixelClient(motors, '/dev/ttyUSB0', 4000000)
            self.dxl_client.connect()
        except Exception:
            try:
                self.dxl_client = DynamixelClient(motors, '/dev/ttyUSB1', 4000000)
                self.dxl_client.connect()
            except Exception:
                self.dxl_client = DynamixelClient(motors, 'COM13', 4000000)
                self.dxl_client.connect()
        

        
        #Enables position-current control mode and the default parameters, it commands a position and then caps the current so the motors don't overload
        self.dxl_client.sync_write(motors, np.ones(len(motors))*5, 11, 1)
        self.dxl_client.set_torque_enabled(motors, True)
        
        self.set_customized_dps()
        
        
        #Max at current (in unit 1ma) so don't overheat and grip too hard #500 normal or #350 for lite
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.curr_lim, 102, 2)
        
        
        self.dxl_client.write_desired_pos(self.motors, self.curr_pos)
        
    def set_customized_dps(self, ):
        # customized dps #
        motors = self.motors
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.kP, 84, 2) # Pgain stiffness     
        self.dxl_client.sync_write([0,4,8], np.ones(3) * (self.kP * 0.9), 84, 2) # Pgain stiffness for side to side should be a bit less
        self.dxl_client.sync_write([1,5,9,12], np.ones(3) * (self.kP * 1.25), 84, 2) # Pgain stiffness for side to side should be a bit less
        
        #### new setting ####
        self.dxl_client.sync_write([1,5,9,12], np.ones(4) * (self.kP * 1.25), 84, 2)
        self.dxl_client.sync_write([0], np.ones(1) * (self.kP * 0.01), 84, 2)
        # self.dxl_client.sync_write([1], np.ones(1) * (100), 84, 2)
        
        self.dxl_client.sync_write([1], np.ones(1) * (self.kP), 84, 2) # version 2 
        
        
        # self.dxl_client.sync_write([2], np.ones(1) * (self.kP * 0.1), 84, 2) 
        # self.dxl_client.sync_write([1], np.ones(1) * (100), 84, 2)
        # self.dxl_client.sync_write([1], np.ones(1) * (self.kP * 0.01), 84, 2) # can work for duck #
        # self.dxl_client.sync_write([13], np.ones(1) * (self.kP * 0.01), 84, 2)
        # self.dxl_client.sync_write([12], np.ones(1) * (self.kP * 0.01), 84, 2)
        #### closed loop duck with dr ####
        self.dxl_client.sync_write([4], np.ones(1) * (self.kP * 0.01), 84, 2)
        self.dxl_client.sync_write([5], np.ones(1) * (0.01 * self.kP), 84, 2)
        self.dxl_client.sync_write([6], np.ones(1) * (0.01 * self.kP), 84, 2)
        #### closed loop duck with dr ####
        #### closed loop duck with dr ####
        self.dxl_client.sync_write([4], np.ones(1) * (self.kP ), 84, 2)
        self.dxl_client.sync_write([5], np.ones(1) * (1 * self.kP), 84, 2)
        self.dxl_client.sync_write([6], np.ones(1) * (1 * self.kP), 84, 2)
        #### closed loop duck with dr ####
        self.dxl_client.sync_write([0], np.ones(1) * (self.kP ), 84, 2)
        # self.dxl_client.sync_write([0], np.ones(1) * (self.kP * 0.01), 84, 2)
        # self.dxl_client.sync_write([4], np.ones(1) * (self.kP * 0.01), 84, 2)
        # self.dxl_client.sync_write([5], np.ones(1) * (0.01 * self.kP), 84, 2)
        
        
        ###### Duck sequences #######
        self.dxl_client.sync_write([13], np.ones(1) * (1 * self.kP), 84, 2)
        self.dxl_client.sync_write([4], np.ones(1) * (self.kP * 0.1), 84, 2)
        self.dxl_client.sync_write([5], np.ones(1) * (0.01 * self.kP), 84, 2)
        # self.dxl_client.sync_write([6], np.ones(1) * (0.01 * self.kP), 84, 2)
        ###### Duck sequences #######
        
        ###### Apple sequences #######
        self.dxl_client.sync_write([13], np.ones(1) * (1 * self.kP), 84, 2)
        self.dxl_client.sync_write([4], np.ones(1) * (self.kP * 1), 84, 2)
        self.dxl_client.sync_write([5], np.ones(1) * (1 * self.kP), 84, 2)
        
        
        # self.dxl_client.sync_write([13], np.ones(1) * (0.1 * self.kP), 84, 2)
        # self.dxl_client.sync_write([4], np.ones(1) * (self.kP * 0.1), 84, 2)
        # self.dxl_client.sync_write([5], np.ones(1) * (0.01 * self.kP), 84, 2)
        #### new setting ####
        
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.kI, 82, 2) # Igain
        
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.kD, 80, 2) # Dgain damping
        self.dxl_client.sync_write([0,4,8], np.ones(3) * (self.kD * 0.9), 80, 2) # Dgain damping for side to side should be a bit less
        self.dxl_client.sync_write([1,5,9,12], np.ones(3) * (self.kD * 1.25), 80, 2) # Dgain damping for side to side should be a bit less
        
        #### new setting ####
        self.dxl_client.sync_write([1,5,9,12], np.ones(4) * (self.kD * 1.25), 80, 2) # Dgain damping for side to side should be a bit less
        # self.dxl_client.sync_write([1], np.ones(1) * (self.kD * 0.01), 80, 2) # Dgain damping for side to side should be a bit less
        #### new setting ####
        
    def set_default_pds(self, ):
        motors = self.motors
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.kP, 84, 2) # Pgain stiffness    
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.kI, 82, 2) # Igain
        self.dxl_client.sync_write(motors, np.ones(len(motors)) * self.kD, 80, 2) # Dgain damping
        

    #Receive LEAP pose and directly control the robot
    def set_leap(self, pose):
        self.prev_pos = self.curr_pos
        self.curr_pos = np.array(pose)
        self.dxl_client.write_desired_pos(self.motors, self.curr_pos)
    #allegro compatibility
    def set_allegro(self, pose):
        pose = lhu.allegro_to_LEAPhand(pose, zeros=False)
        self.prev_pos = self.curr_pos
        self.curr_pos = np.array(pose)
        self.dxl_client.write_desired_pos(self.motors, self.curr_pos)
    #Sim compatibility, first read the sim value in range [-1,1] and then convert to leap
    def set_ones(self, pose):
        pose = self.sim_ones_to_LEAPhand(np.array(pose))
        self.prev_pos = self.curr_pos
        self.curr_pos = np.array(pose)
        self.dxl_client.write_desired_pos(self.motors, self.curr_pos)
    #read position
    def read_pos(self):
        return self.dxl_client.read_pos()
    #read velocity
    def read_vel(self):
        return self.dxl_client.read_vel()
    #read current
    def read_cur(self):
        return self.dxl_client.read_cur()

    def LEAPsim_limits(self,type = "regular"):
        sim_min = np.array([-1.047, -0.314, -0.506, -0.366, -1.047, -0.314, -0.506, -0.366, -1.047, -0.314, -0.506, -0.366, -0.349, -0.47, -1.20, -1.34])
        sim_max = np.array([1.047,    2.23,  1.885,  2.042,  1.047,   2.23,  1.885,  2.042,  1.047,   2.23,  1.885,  2.042,  2.094,  2.443, 1.90,  1.88])
        return sim_min, sim_max
    
    def scale(self,x, lower, upper):
        return (0.5 * (x + 1.0) * (upper - lower) + lower)
    
    def sim_ones_to_LEAPhand(self,joints, hack_thumb = False):
        sim_min, sim_max = self.LEAPsim_limits(type = hack_thumb)
        joints = self.scale(joints, sim_min, sim_max)
        joints = self.LEAPsim_to_LEAPhand(joints)
        return joints
    
    def LEAPsim_to_LEAPhand(self,joints):
        joints = np.array(joints)
        ret_joints = joints + 3.14159
        return ret_joints
